//
//  $Id: WXKBookmarkWindowController.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright FUJIDANA 2006. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKBookmarkWindowController.h"
#import "FJNCoreDataArrayController.h"
#import "FJNIndexedContentArrayController.h"


@implementation WXKBookmarkWindowController


#pragma mark Initialization and deallocation

- (id)init
{
	self = [super initWithWindowNibName:@"BookmarkWindow" storeDirectory:@"Kyopon Utilities" filename:@"bookmarks.wxkbinary" type:NSBinaryStoreType];
	return self;
}

- (void)windowWillLoad
{
	[super windowWillLoad];
	
	[self setWindowFrameAutosaveName:@"BookmarkWindowFrame"];
	
//	[[NSNotificationCenter defaultCenter] addObserver:self
//											 selector:@selector(managedObjectContextDidSave:)
//												 name:NSManagedObjectContextDidSaveNotification
//											   object:[self managedObjectContext]];
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	// Check wheter bookmark folders exist in the managed object context. If they ddoes not exists, create new folders.
	NSMutableArray *dictionaries = [NSMutableArray arrayWithCapacity:20];
	NSDictionary *keyedValues;
	int i;
	for (i = 0; i < 20; i++)
	{
		keyedValues = [NSDictionary dictionaryWithObjectsAndKeys:
			[NSNumber numberWithLong:i], @"order",
			[NSString stringWithFormat:@"%02d", i], @"title",
			nil];
		[dictionaries addObject:keyedValues];
	}
	[[self containerArrayController] initializedObjectsWithDictionaries:dictionaries];

	[[self contentArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"bookmark", @"BookmarkLocalizable", @"childEntityName")];
	[[self containerArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"folder", @"BookmarkLocalizable", @"parentEntityName")];
	[(FJNIndexedContentArrayController *)[self contentArrayController] setIndexerEntityName:@"BookmarkIndexer"];
	
	[self setupToolbarWithIdentifier:@"KyoponBookmarksToolbarIdentifier"];
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:NSManagedObjectContextDidSaveNotification
												  object:[self managedObjectContext]];
	[super dealloc];
}

#pragma mark Methods delegated by NSToolbar

- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
{
	NSToolbarItem *toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
	return toolbarItem;
}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		FJNContainableToolbarNewContentIdentifier,
		FJNContainableToolbarDeleteContentIdentifier,
		NSToolbarSeparatorItemIdentifier,
		WXKToolbarReceiveItemIdentifier,
		WXKToolbarSendItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		FJNContainableToolbarSearchContentIdentifier,
		nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
		FJNContainableToolbarNewContentIdentifier,
		FJNContainableToolbarDeleteContentIdentifier,
		FJNContainableToolbarPreviousContentIdentifier,
		FJNContainableToolbarNextContentIdentifier,
		FJNContainableToolbarPreviousContainerIdentifier,
		FJNContainableToolbarNextContainerIdentifier,
		FJNContainableToolbarDeselectSortIdentifier,
		FJNContainableToolbarSearchContentIdentifier,
		FJNIndexableToolbarReindexSelectionIdentifier,
		WXKToolbarReceiveItemIdentifier,
		WXKToolbarSendItemIdentifier,
		WXKToolbarAddressUtilityItemIdentifier,
//		WXKToolbarBookmarkUtilityItemIdentifier,
		WXKToolbarFileUtilityItemIdentifier,
		WXKToolbarMailUtilityItemIdentifier,
		NSToolbarPrintItemIdentifier,
		//NSToolbarShowColorsItemIdentifier,
		//NSToolbarShowFontsItemIdentifier,
		NSToolbarCustomizeToolbarItemIdentifier,
		NSToolbarSeparatorItemIdentifier,
		NSToolbarSpaceItemIdentifier,
		NSToolbarFlexibleSpaceItemIdentifier,
		nil];
}

@end
